% ENTER SUCCESSIVELY IN THE COMMAND WINDOW
%
% sicstus
% [casapi].
% set(choiceOfSentence(3)).
% silent.
% all.
% [proto].
% run.
%
% AND EDIT THE LAST LINE OF THIS FILE TO CHANGE THE 
% NUMBER OF THE SUPPLIER YOU NEED TO TEST.

:- use_module(library(clpfd)).

% LIST OF SUPPLIERS - USE ONLY NUMBERS

sup(1).
sup(2).
sup(3).
sup(4).

% LIST OF BENEFITS

benefit(hdc).
benefit(adc).
benefit(fdc).
benefit(pdc).

benefit(hsc).
benefit(asc).
benefit(fsc).
benefit(psc).

benefit(hec).
benefit(aec).
benefit(fec).
benefit(pec).

% LIST Of CONTRACT CLAUSES

contractclause(interface).
contractclause(option5).
contractclause(expertise).
contractclause(option6).
contractclause(option4).


% LINKS FROM FEATURES TO BENEFITS

myRule(benefit(hdc,X),[f1(X),f7(X),f10(X)]).
myRule(benefit(hdc,X),[f4(X),f7(X),f10(X)]).
myRule(benefit(hdc,X),[f7(X),f9(X),f10(X)]).

myRule(benefit(adc,X),[f1(X),f3(X),f10(X)]).
myRule(benefit(adc,X),[f1(X),f7(X)]).
myRule(benefit(adc,X),[f1(X),f9(X),f10(X)]).
myRule(benefit(adc,X),[f3(X),f4(X),f10(X)]).
myRule(benefit(adc,X),[f3(X),f9(X),f10(X)]).
myRule(benefit(adc,X),[f4(X),f7(X)]).
myRule(benefit(adc,X),[f4(X),f9(X),f10(X)]).
myRule(benefit(adc,X),[f7(X),f9(X)]).
myRule(benefit(adc,X),[f7(X),f10(X)]).

myRule(benefit(fdc,X),[f3(X),f1(X)]).
myRule(benefit(fdc,X),[f3(X),f4(X)]).
myRule(benefit(fdc,X),[f9(X)]).
myRule(benefit(fdc,X),[f7(X)]).
myRule(benefit(fdc,X),[f3(X),f10(X)]).
myRule(benefit(fdc,X),[f1(X),f10(X)]).
myRule(benefit(fdc,X),[f4(X),f10(X)]).

myRule(benefit(pdc,X),[f1(X)]).
myRule(benefit(pdc,X),[f3(X)]).
myRule(benefit(pdc,X),[f4(X)]).
myRule(benefit(pdc,X),[f7(X)]).
myRule(benefit(pdc,X),[f9(X)]).
myRule(benefit(pdc,X),[f10(X)]).

myRule(benefit(hsc,X),[f1(X),f4(X),f5(X),f8(X)]).
myRule(benefit(hsc,X),[f1(X),f4(X),f5(X),f9(X)]).
myRule(benefit(hsc,X),[f1(X),f4(X),f8(X),f9(X)]).
myRule(benefit(hsc,X),[f1(X),f5(X),f8(X),f9(X)]).
myRule(benefit(hsc,X),[f4(X),f5(X),f8(X),f9(X)]).

myRule(benefit(asc,X),[f1(X),f4(X),f5(X)]).
myRule(benefit(asc,X),[f1(X),f4(X),f8(X)]).
myRule(benefit(asc,X),[f1(X),f4(X),f9(X)]).
myRule(benefit(asc,X),[f1(X),f5(X),f8(X)]).
myRule(benefit(asc,X),[f1(X),f5(X),f9(X)]).
myRule(benefit(asc,X),[f1(X),f8(X),f9(X)]).
myRule(benefit(asc,X),[f4(X),f5(X),f8(X)]).
myRule(benefit(asc,X),[f4(X),f8(X),f9(X)]).
myRule(benefit(asc,X),[f5(X),f8(X),f9(X)]).

myRule(benefit(fsc,X),[f1(X),f4(X)]).
myRule(benefit(fsc,X),[f1(X),f5(X)]).
myRule(benefit(fsc,X),[f1(X),f8(X)]).
myRule(benefit(fsc,X),[f1(X),f9(X)]).
myRule(benefit(fsc,X),[f4(X),f5(X)]).
myRule(benefit(fsc,X),[f4(X),f8(X)]).
myRule(benefit(fsc,X),[f4(X),f9(X)]).
myRule(benefit(fsc,X),[f5(X),f8(X)]).
myRule(benefit(fsc,X),[f5(X),f9(X)]).
myRule(benefit(fsc,X),[f8(X),f9(X)]).

myRule(benefit(psc,X),[f1(X)]).
myRule(benefit(psc,X),[f4(X)]).
myRule(benefit(psc,X),[f5(X)]).
myRule(benefit(psc,X),[f8(X)]).
myRule(benefit(psc,X),[f9(X)]).

myRule(benefit(hec,X),[f1(X),f2(X),f5(X),f6(X)]).

myRule(benefit(aec,X),[f1(X),f2(X),f5(X)]).
myRule(benefit(aec,X),[f1(X),f2(X),f6(X)]).
myRule(benefit(aec,X),[f1(X),f5(X),f6(X)]).
myRule(benefit(aec,X),[f2(X),f5(X),f6(X)]).

myRule(benefit(fec,X),[f1(X),f2(X)]).
myRule(benefit(fec,X),[f1(X),f5(X)]).
myRule(benefit(fec,X),[f1(X),f6(X)]).
myRule(benefit(fec,X),[f2(X),f5(X)]).
myRule(benefit(fec,X),[f2(X),f6(X)]).
myRule(benefit(fec,X),[f5(X),f6(X)]).

myRule(benefit(pec,X),[f1(X)]).
myRule(benefit(pec,X),[f2(X)]).
myRule(benefit(pec,X),[f5(X)]).
myRule(benefit(pec,X),[f6(X)]).

% OFFERS FROM THE SUPPLIERS

myRule(f1(1),[]).
myRule(f2(1),[interface]).
myRule(f5(1),[]).
myRule(f8(1),[]).
myRule(f10(1),[]).

myRule(f2(2),[]).
myRule(f5(2),[option5]).
myRule(f6(2),[]).
myRule(f8(2),[]).
myRule(f9(2),[]).

myRule(f1(3),[]).
myRule(f4(3),[expertise]).
myRule(f5(3),[]).
myRule(f6(3),[option6]).
myRule(f9(3),[]).

myRule(f1(4),[]).
myRule(f4(4),[option4]).
myRule(f5(4),[]).
myRule(f8(4),[]).
myRule(f9(4),[]).

% ATTACK RULES

myRule(c(X,Y,B),[benefit(B,Y),mnot(B,X)]).

% ASSUMPTIONS

myAsm(sup(X)).
myAsm(mnot(B,X)).
myAsm(Q) :- contractclause(Q).

% CONTRARY RELATION

contrary(sup(X),c(X,Y,B)) :- sup(X), sup(Y), all_different([X,Y]), benefit(B).
contrary(mnot(B,X),benefit(B,X)) :- benefit(B), sup(X).
contrary(Q,nothing) :- contractclause(Q).

% QUERY LINE

toBeProved([sup(3)]).